[cs2modrewrite](https://github.com/threatexpress/cs2modrewrite) is a set of Python tools that can automatically produce rewrite rules for Apache and Nginx.

First, one configuration that needs to be added to `webbug_getonly.profile` (or whichever profile you've chosen to use) is an explicit user agent, as this is required by the script.

set useragent "Mozilla/5.0 (Windows NT 10.0; Trident/7.0; rv:11.0) like Gecko";

  This is a global option, so goes outside of the `http-get` and `http-post` blocks.

  

We can then run `cs2modrewrite.py`.

ubuntu@teamserver ~/cs2modrewrite (master)> python3 cs2modrewrite.py -i ~/cobaltstrike/c2-profiles/normal/webbug_getonly.profile -c https://localhost:8443 -r https://www.google.com/ -o webbug_getonly_htaccess

Where:

-   `-i` is the malleable C2 profile.
-   `-c` is the location of the Team Server.
-   `-r` is a URL to redirect "invalid" traffic to.
-   `-o` is an output file.

  

ubuntu@teamserver ~/cs2modrewrite (master)> cat webbug_getonly_htaccess 

########################################
## .htaccess START
RewriteEngine On

## (Optional)
## Scripted Web Delivery
## Uncomment and adjust as needed
#RewriteCond %{REQUEST_URI} ^/css/style1.css?$
#RewriteCond %{HTTP_USER_AGENT} ^$
#RewriteRule ^.*$ "http://TEAMSERVER%{REQUEST_URI}" [P,L]

## Default Beacon Staging Support (/1234)
RewriteCond %{{REQUEST_METHOD}} GET [NC]
RewriteCond %{{REQUEST_URI}} ^/..../?$
RewriteCond %{{HTTP_USER_AGENT}} "{ua}"
RewriteRule ^.*$ "{c2server}%{{REQUEST_URI}}" [P,L]

## C2 Traffic (HTTP-GET, HTTP-POST, HTTP-STAGER URIs)
## Logic: If a requested URI AND the User-Agent matches, proxy the connection to the Teamserver
## Consider adding other HTTP checks to fine tune the check.  (HTTP Cookie, HTTP Referer, HTTP Query String, etc)
## Refer to http://httpd.apache.org/docs/current/mod/mod_rewrite.html
## Only allow GET and POST methods to pass to the C2 server
RewriteCond %{REQUEST_METHOD} ^(GET|POST) [NC]
## Profile URIs
RewriteCond %{REQUEST_URI} ^(/___utm.gif.*|/__init.gif.*|/_init.gif.*|/__utm.gif.*)$
## Profile UserAgent
RewriteCond %{HTTP_USER_AGENT} "Mozilla/5.0 \(Windows NT 10.0; Trident/7.0; rv:11.0\) like Gecko"
RewriteRule ^.*$ "https://localhost:8443%{REQUEST_URI}" [P,L]

## Redirect all other traffic here
RewriteRule ^.*$ https://www.google.com//? [L,R=302]

## .htaccess END
########################################

  

We can then overwrite the content of our `.htaccess` file with this output and try it out.

  As stated in the tool's README, the output may need tweaking to work exactly right, but the heavy lifting has been done.
 